/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroup;

public final class DescribeOptionGroupsPaginator
implements SdkIterable<DescribeOptionGroupsResponse> {
    private final RDSClient client;
    private final DescribeOptionGroupsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeOptionGroupsPaginator(RDSClient client, DescribeOptionGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOptionGroupsResponseFetcher();
    }

    public Iterator<DescribeOptionGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<OptionGroup> optionGroupsList() {
        Function<DescribeOptionGroupsResponse, Iterator> getIterator = response -> response != null ? response.optionGroupsList().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeOptionGroupsResponseFetcher
    implements NextPageFetcher<DescribeOptionGroupsResponse> {
        private DescribeOptionGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeOptionGroupsResponse nextPage(DescribeOptionGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupsPaginator.this.client.describeOptionGroups(DescribeOptionGroupsPaginator.this.firstRequest);
            }
            return DescribeOptionGroupsPaginator.this.client.describeOptionGroups((DescribeOptionGroupsRequest)((Object)DescribeOptionGroupsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

