/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RebootDBInstanceRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, RebootDBInstanceRequest> {
    private final String dbInstanceIdentifier;
    private final Boolean forceFailover;

    private RebootDBInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.forceFailover = builder.forceFailover;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Boolean forceFailover() {
        return this.forceFailover;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceFailover());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootDBInstanceRequest)) {
            return false;
        }
        RebootDBInstanceRequest other = (RebootDBInstanceRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.forceFailover(), other.forceFailover());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.forceFailover() != null) {
            sb.append("ForceFailover: ").append(this.forceFailover()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "ForceFailover": {
                return Optional.of(clazz.cast(this.forceFailover()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Boolean forceFailover;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootDBInstanceRequest model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.forceFailover(model.forceFailover);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Boolean getForceFailover() {
            return this.forceFailover;
        }

        @Override
        public final Builder forceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
            return this;
        }

        public final void setForceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RebootDBInstanceRequest build() {
            return new RebootDBInstanceRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, RebootDBInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder forceFailover(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

