/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceActionsCopier;
import software.amazon.awssdk.services.rds.model.RDSResponse;
import software.amazon.awssdk.services.rds.model.ResourcePendingMaintenanceActions;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribePendingMaintenanceActionsResponse
extends RDSResponse
implements ToCopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
    private final List<ResourcePendingMaintenanceActions> pendingMaintenanceActions;
    private final String marker;

    private DescribePendingMaintenanceActionsResponse(BuilderImpl builder) {
        super(builder);
        this.pendingMaintenanceActions = builder.pendingMaintenanceActions;
        this.marker = builder.marker;
    }

    public List<ResourcePendingMaintenanceActions> pendingMaintenanceActions() {
        return this.pendingMaintenanceActions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingMaintenanceActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePendingMaintenanceActionsResponse)) {
            return false;
        }
        DescribePendingMaintenanceActionsResponse other = (DescribePendingMaintenanceActionsResponse)((Object)obj);
        return Objects.equals(this.pendingMaintenanceActions(), other.pendingMaintenanceActions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.pendingMaintenanceActions() != null) {
            sb.append("PendingMaintenanceActions: ").append(this.pendingMaintenanceActions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PendingMaintenanceActions": {
                return Optional.of(clazz.cast(this.pendingMaintenanceActions()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSResponse.BuilderImpl
    implements Builder {
        private List<ResourcePendingMaintenanceActions> pendingMaintenanceActions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePendingMaintenanceActionsResponse model) {
            this.pendingMaintenanceActions(model.pendingMaintenanceActions);
            this.marker(model.marker);
        }

        public final Collection<ResourcePendingMaintenanceActions.Builder> getPendingMaintenanceActions() {
            return this.pendingMaintenanceActions != null ? (Collection)this.pendingMaintenanceActions.stream().map(ResourcePendingMaintenanceActions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copy(pendingMaintenanceActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... pendingMaintenanceActions) {
            this.pendingMaintenanceActions(Arrays.asList(pendingMaintenanceActions));
            return this;
        }

        public final void setPendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions.BuilderImpl> pendingMaintenanceActions) {
            this.pendingMaintenanceActions = PendingMaintenanceActionsCopier.copyFromBuilder(pendingMaintenanceActions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribePendingMaintenanceActionsResponse build() {
            return new DescribePendingMaintenanceActionsResponse(this);
        }
    }

    public static interface Builder
    extends RDSResponse.Builder,
    CopyableBuilder<Builder, DescribePendingMaintenanceActionsResponse> {
        public Builder pendingMaintenanceActions(Collection<ResourcePendingMaintenanceActions> var1);

        public Builder pendingMaintenanceActions(ResourcePendingMaintenanceActions ... var1);

        public Builder marker(String var1);
    }
}

