/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDBClusterParameterGroupRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, CreateDBClusterParameterGroupRequest> {
    private final String dbClusterParameterGroupName;
    private final String dbParameterGroupFamily;
    private final String description;
    private final List<Tag> tags;

    private CreateDBClusterParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public String description() {
        return this.description;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBClusterParameterGroupRequest)) {
            return false;
        }
        CreateDBClusterParameterGroupRequest other = (CreateDBClusterParameterGroupRequest)((Object)obj);
        return Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbClusterParameterGroupName() != null) {
            sb.append("DBClusterParameterGroupName: ").append(this.dbClusterParameterGroupName()).append(",");
        }
        if (this.dbParameterGroupFamily() != null) {
            sb.append("DBParameterGroupFamily: ").append(this.dbParameterGroupFamily()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterParameterGroupName": {
                return Optional.of(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "DBParameterGroupFamily": {
                return Optional.of(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String dbClusterParameterGroupName;
        private String dbParameterGroupFamily;
        private String description;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDBClusterParameterGroupRequest model) {
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getDBClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final void setDBClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDBClusterParameterGroupRequest build() {
            return new CreateDBClusterParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, CreateDBClusterParameterGroupRequest> {
        public Builder dbClusterParameterGroupName(String var1);

        public Builder dbParameterGroupFamily(String var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

