/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyOptionGroupRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, CopyOptionGroupRequest> {
    private final String sourceOptionGroupIdentifier;
    private final String targetOptionGroupIdentifier;
    private final String targetOptionGroupDescription;
    private final List<Tag> tags;

    private CopyOptionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceOptionGroupIdentifier = builder.sourceOptionGroupIdentifier;
        this.targetOptionGroupIdentifier = builder.targetOptionGroupIdentifier;
        this.targetOptionGroupDescription = builder.targetOptionGroupDescription;
        this.tags = builder.tags;
    }

    public String sourceOptionGroupIdentifier() {
        return this.sourceOptionGroupIdentifier;
    }

    public String targetOptionGroupIdentifier() {
        return this.targetOptionGroupIdentifier;
    }

    public String targetOptionGroupDescription() {
        return this.targetOptionGroupDescription;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceOptionGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOptionGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetOptionGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyOptionGroupRequest)) {
            return false;
        }
        CopyOptionGroupRequest other = (CopyOptionGroupRequest)((Object)obj);
        return Objects.equals(this.sourceOptionGroupIdentifier(), other.sourceOptionGroupIdentifier()) && Objects.equals(this.targetOptionGroupIdentifier(), other.targetOptionGroupIdentifier()) && Objects.equals(this.targetOptionGroupDescription(), other.targetOptionGroupDescription()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceOptionGroupIdentifier() != null) {
            sb.append("SourceOptionGroupIdentifier: ").append(this.sourceOptionGroupIdentifier()).append(",");
        }
        if (this.targetOptionGroupIdentifier() != null) {
            sb.append("TargetOptionGroupIdentifier: ").append(this.targetOptionGroupIdentifier()).append(",");
        }
        if (this.targetOptionGroupDescription() != null) {
            sb.append("TargetOptionGroupDescription: ").append(this.targetOptionGroupDescription()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceOptionGroupIdentifier": {
                return Optional.of(clazz.cast(this.sourceOptionGroupIdentifier()));
            }
            case "TargetOptionGroupIdentifier": {
                return Optional.of(clazz.cast(this.targetOptionGroupIdentifier()));
            }
            case "TargetOptionGroupDescription": {
                return Optional.of(clazz.cast(this.targetOptionGroupDescription()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String sourceOptionGroupIdentifier;
        private String targetOptionGroupIdentifier;
        private String targetOptionGroupDescription;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyOptionGroupRequest model) {
            this.sourceOptionGroupIdentifier(model.sourceOptionGroupIdentifier);
            this.targetOptionGroupIdentifier(model.targetOptionGroupIdentifier);
            this.targetOptionGroupDescription(model.targetOptionGroupDescription);
            this.tags(model.tags);
        }

        public final String getSourceOptionGroupIdentifier() {
            return this.sourceOptionGroupIdentifier;
        }

        @Override
        public final Builder sourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
            this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
            return this;
        }

        public final void setSourceOptionGroupIdentifier(String sourceOptionGroupIdentifier) {
            this.sourceOptionGroupIdentifier = sourceOptionGroupIdentifier;
        }

        public final String getTargetOptionGroupIdentifier() {
            return this.targetOptionGroupIdentifier;
        }

        @Override
        public final Builder targetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
            this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
            return this;
        }

        public final void setTargetOptionGroupIdentifier(String targetOptionGroupIdentifier) {
            this.targetOptionGroupIdentifier = targetOptionGroupIdentifier;
        }

        public final String getTargetOptionGroupDescription() {
            return this.targetOptionGroupDescription;
        }

        @Override
        public final Builder targetOptionGroupDescription(String targetOptionGroupDescription) {
            this.targetOptionGroupDescription = targetOptionGroupDescription;
            return this;
        }

        public final void setTargetOptionGroupDescription(String targetOptionGroupDescription) {
            this.targetOptionGroupDescription = targetOptionGroupDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CopyOptionGroupRequest build() {
            return new CopyOptionGroupRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, CopyOptionGroupRequest> {
        public Builder sourceOptionGroupIdentifier(String var1);

        public Builder targetOptionGroupIdentifier(String var1);

        public Builder targetOptionGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

