/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.rds.model.RDSRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyDBClusterParameterGroupRequest
extends RDSRequest
implements ToCopyableBuilder<Builder, CopyDBClusterParameterGroupRequest> {
    private final String sourceDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupDescription;
    private final List<Tag> tags;

    private CopyDBClusterParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBClusterParameterGroupIdentifier = builder.sourceDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupIdentifier = builder.targetDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupDescription = builder.targetDBClusterParameterGroupDescription;
        this.tags = builder.tags;
    }

    public String sourceDBClusterParameterGroupIdentifier() {
        return this.sourceDBClusterParameterGroupIdentifier;
    }

    public String targetDBClusterParameterGroupIdentifier() {
        return this.targetDBClusterParameterGroupIdentifier;
    }

    public String targetDBClusterParameterGroupDescription() {
        return this.targetDBClusterParameterGroupDescription;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBClusterParameterGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBClusterParameterGroupRequest)) {
            return false;
        }
        CopyDBClusterParameterGroupRequest other = (CopyDBClusterParameterGroupRequest)((Object)obj);
        return Objects.equals(this.sourceDBClusterParameterGroupIdentifier(), other.sourceDBClusterParameterGroupIdentifier()) && Objects.equals(this.targetDBClusterParameterGroupIdentifier(), other.targetDBClusterParameterGroupIdentifier()) && Objects.equals(this.targetDBClusterParameterGroupDescription(), other.targetDBClusterParameterGroupDescription()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceDBClusterParameterGroupIdentifier() != null) {
            sb.append("SourceDBClusterParameterGroupIdentifier: ").append(this.sourceDBClusterParameterGroupIdentifier()).append(",");
        }
        if (this.targetDBClusterParameterGroupIdentifier() != null) {
            sb.append("TargetDBClusterParameterGroupIdentifier: ").append(this.targetDBClusterParameterGroupIdentifier()).append(",");
        }
        if (this.targetDBClusterParameterGroupDescription() != null) {
            sb.append("TargetDBClusterParameterGroupDescription: ").append(this.targetDBClusterParameterGroupDescription()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBClusterParameterGroupIdentifier": {
                return Optional.of(clazz.cast(this.sourceDBClusterParameterGroupIdentifier()));
            }
            case "TargetDBClusterParameterGroupIdentifier": {
                return Optional.of(clazz.cast(this.targetDBClusterParameterGroupIdentifier()));
            }
            case "TargetDBClusterParameterGroupDescription": {
                return Optional.of(clazz.cast(this.targetDBClusterParameterGroupDescription()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RDSRequest.BuilderImpl
    implements Builder {
        private String sourceDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupDescription;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDBClusterParameterGroupRequest model) {
            this.sourceDBClusterParameterGroupIdentifier(model.sourceDBClusterParameterGroupIdentifier);
            this.targetDBClusterParameterGroupIdentifier(model.targetDBClusterParameterGroupIdentifier);
            this.targetDBClusterParameterGroupDescription(model.targetDBClusterParameterGroupDescription);
            this.tags(model.tags);
        }

        public final String getSourceDBClusterParameterGroupIdentifier() {
            return this.sourceDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder sourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setSourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupIdentifier() {
            return this.targetDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder targetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setTargetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupDescription() {
            return this.targetDBClusterParameterGroupDescription;
        }

        @Override
        public final Builder targetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
            return this;
        }

        public final void setTargetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CopyDBClusterParameterGroupRequest build() {
            return new CopyDBClusterParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends RDSRequest.Builder,
    CopyableBuilder<Builder, CopyDBClusterParameterGroupRequest> {
        public Builder sourceDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

