/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.RecurringCharge;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;
import software.amazon.awssdk.services.rds.transform.RecurringChargeUnmarshaller;

public class ReservedDBInstanceUnmarshaller
implements Unmarshaller<ReservedDBInstance, StaxUnmarshallerContext> {
    private static final ReservedDBInstanceUnmarshaller INSTANCE = new ReservedDBInstanceUnmarshaller();

    public ReservedDBInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        ReservedDBInstance.Builder reservedDBInstance;
        block19: {
            reservedDBInstance = ReservedDBInstance.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<RecurringCharge> recurringCharges = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    reservedDBInstance.recurringCharges(recurringCharges);
                    break block19;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ReservedDBInstanceId", targetDepth)) {
                        reservedDBInstance.reservedDBInstanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReservedDBInstancesOfferingId", targetDepth)) {
                        reservedDBInstance.reservedDBInstancesOfferingId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBInstanceClass", targetDepth)) {
                        reservedDBInstance.dbInstanceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StartTime", targetDepth)) {
                        reservedDBInstance.startTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Duration", targetDepth)) {
                        reservedDBInstance.duration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("FixedPrice", targetDepth)) {
                        reservedDBInstance.fixedPrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("UsagePrice", targetDepth)) {
                        reservedDBInstance.usagePrice(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CurrencyCode", targetDepth)) {
                        reservedDBInstance.currencyCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBInstanceCount", targetDepth)) {
                        reservedDBInstance.dbInstanceCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ProductDescription", targetDepth)) {
                        reservedDBInstance.productDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OfferingType", targetDepth)) {
                        reservedDBInstance.offeringType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MultiAZ", targetDepth)) {
                        reservedDBInstance.multiAZ(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("State", targetDepth)) {
                        reservedDBInstance.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RecurringCharges", targetDepth)) {
                        recurringCharges = new ArrayList<RecurringCharge>();
                        continue;
                    }
                    if (context.testExpression("RecurringCharges/RecurringCharge", targetDepth)) {
                        recurringCharges.add(RecurringChargeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("ReservedDBInstanceArn", targetDepth)) continue;
                    reservedDBInstance.reservedDBInstanceArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            reservedDBInstance.recurringCharges(recurringCharges);
        }
        return (ReservedDBInstance)reservedDBInstance.build();
    }

    public static ReservedDBInstanceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

