/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.RebootDBInstanceRequest;

public class RebootDBInstanceRequestMarshaller
implements Marshaller<Request<RebootDBInstanceRequest>, RebootDBInstanceRequest> {
    public Request<RebootDBInstanceRequest> marshall(RebootDBInstanceRequest rebootDBInstanceRequest) {
        if (rebootDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "RebootDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (rebootDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)rebootDBInstanceRequest.dbInstanceIdentifier()));
        }
        if (rebootDBInstanceRequest.forceFailover() != null) {
            request.addParameter("ForceFailover", StringUtils.fromBoolean((Boolean)rebootDBInstanceRequest.forceFailover()));
        }
        return request;
    }
}

