/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DoubleRange;

public class DoubleRangeUnmarshaller
implements Unmarshaller<DoubleRange, StaxUnmarshallerContext> {
    private static final DoubleRangeUnmarshaller INSTANCE = new DoubleRangeUnmarshaller();

    public DoubleRange unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DoubleRange.Builder doubleRange = DoubleRange.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("From", targetDepth)) {
                    doubleRange.from(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("To", targetDepth)) continue;
                doubleRange.to(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DoubleRange)doubleRange.build();
    }

    public static DoubleRangeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

