/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeReservedDBInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedDBInstancesOfferingsRequest>, DescribeReservedDBInstancesOfferingsRequest> {
    public Request<DescribeReservedDBInstancesOfferingsRequest> marshall(DescribeReservedDBInstancesOfferingsRequest describeReservedDBInstancesOfferingsRequest) {
        List<Filter> filtersList;
        if (describeReservedDBInstancesOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedDBInstancesOfferingsRequest, "RDSClient");
        request.addParameter("Action", "DescribeReservedDBInstancesOfferings");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedDBInstancesOfferingsRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.reservedDBInstancesOfferingId()));
        }
        if (describeReservedDBInstancesOfferingsRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.dbInstanceClass()));
        }
        if (describeReservedDBInstancesOfferingsRequest.duration() != null) {
            request.addParameter("Duration", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.duration()));
        }
        if (describeReservedDBInstancesOfferingsRequest.productDescription() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.productDescription()));
        }
        if (describeReservedDBInstancesOfferingsRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.offeringType()));
        }
        if (describeReservedDBInstancesOfferingsRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)describeReservedDBInstancesOfferingsRequest.multiAZ()));
        }
        if ((filtersList = describeReservedDBInstancesOfferingsRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeReservedDBInstancesOfferingsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeReservedDBInstancesOfferingsRequest.maxRecords()));
        }
        if (describeReservedDBInstancesOfferingsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeReservedDBInstancesOfferingsRequest.marker()));
        }
        return request;
    }
}

