/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DescribeEventsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeEventsRequestMarshaller
implements Marshaller<Request<DescribeEventsRequest>, DescribeEventsRequest> {
    public Request<DescribeEventsRequest> marshall(DescribeEventsRequest describeEventsRequest) {
        List<Filter> filtersList;
        List<String> eventCategoriesList;
        if (describeEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeEventsRequest, "RDSClient");
        request.addParameter("Action", "DescribeEvents");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeEventsRequest.sourceIdentifier() != null) {
            request.addParameter("SourceIdentifier", StringUtils.fromString((String)describeEventsRequest.sourceIdentifier()));
        }
        if (describeEventsRequest.sourceTypeString() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)describeEventsRequest.sourceTypeString()));
        }
        if (describeEventsRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromInstant((Instant)describeEventsRequest.startTime()));
        }
        if (describeEventsRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromInstant((Instant)describeEventsRequest.endTime()));
        }
        if (describeEventsRequest.duration() != null) {
            request.addParameter("Duration", StringUtils.fromInteger((Integer)describeEventsRequest.duration()));
        }
        if ((eventCategoriesList = describeEventsRequest.eventCategories()) != null) {
            if (!eventCategoriesList.isEmpty()) {
                int eventCategoriesListIndex = 1;
                for (String eventCategoriesListValue : eventCategoriesList) {
                    if (eventCategoriesListValue != null) {
                        request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)eventCategoriesListValue));
                    }
                    ++eventCategoriesListIndex;
                }
            } else {
                request.addParameter("EventCategories", "");
            }
        }
        if ((filtersList = describeEventsRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeEventsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeEventsRequest.maxRecords()));
        }
        if (describeEventsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeEventsRequest.marker()));
        }
        return request;
    }
}

