/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;

public class AuthorizeDBSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeDBSecurityGroupIngressRequest>, AuthorizeDBSecurityGroupIngressRequest> {
    public Request<AuthorizeDBSecurityGroupIngressRequest> marshall(AuthorizeDBSecurityGroupIngressRequest authorizeDBSecurityGroupIngressRequest) {
        if (authorizeDBSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeDBSecurityGroupIngressRequest, "RDSClient");
        request.addParameter("Action", "AuthorizeDBSecurityGroupIngress");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeDBSecurityGroupIngressRequest.dbSecurityGroupName() != null) {
            request.addParameter("DBSecurityGroupName", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.dbSecurityGroupName()));
        }
        if (authorizeDBSecurityGroupIngressRequest.cidrip() != null) {
            request.addParameter("CIDRIP", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.cidrip()));
        }
        if (authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupId() != null) {
            request.addParameter("EC2SecurityGroupId", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupId()));
        }
        if (authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringUtils.fromString((String)authorizeDBSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

