/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDBInstancesResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;

public final class DescribeReservedDBInstancesPaginator
implements SdkIterable<DescribeReservedDBInstancesResponse> {
    private final RDSClient client;
    private final DescribeReservedDBInstancesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeReservedDBInstancesPaginator(RDSClient client, DescribeReservedDBInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedDBInstancesResponseFetcher();
    }

    public Iterator<DescribeReservedDBInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ReservedDBInstance> reservedDBInstances() {
        Function<DescribeReservedDBInstancesResponse, Iterator> getIterator = response -> response != null ? response.reservedDBInstances().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeReservedDBInstancesResponseFetcher
    implements NextPageFetcher<DescribeReservedDBInstancesResponse> {
        private DescribeReservedDBInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDBInstancesResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedDBInstancesResponse nextPage(DescribeReservedDBInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesPaginator.this.client.describeReservedDBInstances(DescribeReservedDBInstancesPaginator.this.firstRequest);
            }
            return DescribeReservedDBInstancesPaginator.this.client.describeReservedDBInstances((DescribeReservedDBInstancesRequest)((Object)DescribeReservedDBInstancesPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

