/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDBInstanceOptionsResponse;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption;

public final class DescribeOrderableDBInstanceOptionsPaginator
implements SdkIterable<DescribeOrderableDBInstanceOptionsResponse> {
    private final RDSClient client;
    private final DescribeOrderableDBInstanceOptionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeOrderableDBInstanceOptionsPaginator(RDSClient client, DescribeOrderableDBInstanceOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeOrderableDBInstanceOptionsResponseFetcher();
    }

    public Iterator<DescribeOrderableDBInstanceOptionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        Function<DescribeOrderableDBInstanceOptionsResponse, Iterator> getIterator = response -> response != null ? response.orderableDBInstanceOptions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeOrderableDBInstanceOptionsResponseFetcher
    implements NextPageFetcher<DescribeOrderableDBInstanceOptionsResponse> {
        private DescribeOrderableDBInstanceOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableDBInstanceOptionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeOrderableDBInstanceOptionsResponse nextPage(DescribeOrderableDBInstanceOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableDBInstanceOptionsPaginator.this.client.describeOrderableDBInstanceOptions(DescribeOrderableDBInstanceOptionsPaginator.this.firstRequest);
            }
            return DescribeOrderableDBInstanceOptionsPaginator.this.client.describeOrderableDBInstanceOptions((DescribeOrderableDBInstanceOptionsRequest)((Object)DescribeOrderableDBInstanceOptionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

