/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeDBParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBParametersResponse;
import software.amazon.awssdk.services.rds.model.Parameter;

public final class DescribeDBParametersPaginator
implements SdkIterable<DescribeDBParametersResponse> {
    private final RDSClient client;
    private final DescribeDBParametersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeDBParametersPaginator(RDSClient client, DescribeDBParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBParametersResponseFetcher();
    }

    public Iterator<DescribeDBParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Parameter> parameters() {
        Function<DescribeDBParametersResponse, Iterator> getIterator = response -> response != null ? response.parameters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeDBParametersResponseFetcher
    implements NextPageFetcher<DescribeDBParametersResponse> {
        private DescribeDBParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBParametersResponse nextPage(DescribeDBParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParametersPaginator.this.client.describeDBParameters(DescribeDBParametersPaginator.this.firstRequest);
            }
            return DescribeDBParametersPaginator.this.client.describeDBParameters((DescribeDBParametersRequest)((Object)DescribeDBParametersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

