/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDBClusterSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDBClusterSnapshotRequest> {
    private final String dbClusterSnapshotIdentifier;
    private final String dbClusterIdentifier;
    private final List<Tag> tags;

    private CreateDBClusterSnapshotRequest(BuilderImpl builder) {
        this.dbClusterSnapshotIdentifier = builder.dbClusterSnapshotIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.tags = builder.tags;
    }

    public String dbClusterSnapshotIdentifier() {
        return this.dbClusterSnapshotIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBClusterSnapshotRequest)) {
            return false;
        }
        CreateDBClusterSnapshotRequest other = (CreateDBClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.dbClusterSnapshotIdentifier(), other.dbClusterSnapshotIdentifier()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbClusterSnapshotIdentifier() != null) {
            sb.append("DBClusterSnapshotIdentifier: ").append(this.dbClusterSnapshotIdentifier()).append(",");
        }
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBClusterSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterSnapshotIdentifier()));
            }
            case "DBClusterIdentifier": {
                return Optional.of(clazz.cast(this.dbClusterIdentifier()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbClusterSnapshotIdentifier;
        private String dbClusterIdentifier;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDBClusterSnapshotRequest model) {
            this.dbClusterSnapshotIdentifier(model.dbClusterSnapshotIdentifier);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.tags(model.tags);
        }

        public final String getDBClusterSnapshotIdentifier() {
            return this.dbClusterSnapshotIdentifier;
        }

        @Override
        public final Builder dbClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
            return this;
        }

        public final void setDBClusterSnapshotIdentifier(String dbClusterSnapshotIdentifier) {
            this.dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public CreateDBClusterSnapshotRequest build() {
            return new CreateDBClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDBClusterSnapshotRequest> {
        public Builder dbClusterSnapshotIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

