/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.SourceRegion;

public class SourceRegionUnmarshaller
implements Unmarshaller<SourceRegion, StaxUnmarshallerContext> {
    private static final SourceRegionUnmarshaller INSTANCE = new SourceRegionUnmarshaller();

    public SourceRegion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        SourceRegion.Builder sourceRegion = SourceRegion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("RegionName", targetDepth)) {
                    sourceRegion.regionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Endpoint", targetDepth)) {
                    sourceRegion.endpoint(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                sourceRegion.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (SourceRegion)sourceRegion.build();
    }

    public static SourceRegionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

