/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class PurchaseReservedDBInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedDBInstancesOfferingRequest>, PurchaseReservedDBInstancesOfferingRequest> {
    public Request<PurchaseReservedDBInstancesOfferingRequest> marshall(PurchaseReservedDBInstancesOfferingRequest purchaseReservedDBInstancesOfferingRequest) {
        List<Tag> tagsList;
        if (purchaseReservedDBInstancesOfferingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseReservedDBInstancesOfferingRequest, "RDSClient");
        request.addParameter("Action", "PurchaseReservedDBInstancesOffering");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseReservedDBInstancesOfferingRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringUtils.fromString((String)purchaseReservedDBInstancesOfferingRequest.reservedDBInstancesOfferingId()));
        }
        if (purchaseReservedDBInstancesOfferingRequest.reservedDBInstanceId() != null) {
            request.addParameter("ReservedDBInstanceId", StringUtils.fromString((String)purchaseReservedDBInstancesOfferingRequest.reservedDBInstanceId()));
        }
        if (purchaseReservedDBInstancesOfferingRequest.dbInstanceCount() != null) {
            request.addParameter("DBInstanceCount", StringUtils.fromInteger((Integer)purchaseReservedDBInstancesOfferingRequest.dbInstanceCount()));
        }
        if ((tagsList = purchaseReservedDBInstancesOfferingRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;
                for (Tag tagsListValue : tagsList) {
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++tagsListIndex;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        return request;
    }
}

