/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DescribeDBParametersRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDBParametersRequestMarshaller
implements Marshaller<Request<DescribeDBParametersRequest>, DescribeDBParametersRequest> {
    public Request<DescribeDBParametersRequest> marshall(DescribeDBParametersRequest describeDBParametersRequest) {
        List<Filter> filtersList;
        if (describeDBParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBParametersRequest, "RDSClient");
        request.addParameter("Action", "DescribeDBParameters");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBParametersRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString((String)describeDBParametersRequest.dbParameterGroupName()));
        }
        if (describeDBParametersRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)describeDBParametersRequest.source()));
        }
        if ((filtersList = describeDBParametersRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeDBParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBParametersRequest.maxRecords()));
        }
        if (describeDBParametersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBParametersRequest.marker()));
        }
        return request;
    }
}

