/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.CreateDBClusterRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDBClusterRequestMarshaller
implements Marshaller<Request<CreateDBClusterRequest>, CreateDBClusterRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateDBClusterRequest> marshall(CreateDBClusterRequest createDBClusterRequest) {
        List<Tag> tagsList;
        List<String> vpcSecurityGroupIdsList;
        if (createDBClusterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDBClusterRequest, "RDSClient");
        request.addParameter("Action", "CreateDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> availabilityZonesList = createDBClusterRequest.availabilityZones();
        if (availabilityZonesList != null) {
            if (!availabilityZonesList.isEmpty()) {
                int availabilityZonesListIndex = 1;
                for (String string : availabilityZonesList) {
                    if (string != null) {
                        request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString((String)string));
                    }
                    ++availabilityZonesListIndex;
                }
            } else {
                request.addParameter("AvailabilityZones", "");
            }
        }
        if (createDBClusterRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)createDBClusterRequest.backupRetentionPeriod()));
        }
        if (createDBClusterRequest.characterSetName() != null) {
            request.addParameter("CharacterSetName", StringUtils.fromString((String)createDBClusterRequest.characterSetName()));
        }
        if (createDBClusterRequest.databaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString((String)createDBClusterRequest.databaseName()));
        }
        if (createDBClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString((String)createDBClusterRequest.dbClusterIdentifier()));
        }
        if (createDBClusterRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString((String)createDBClusterRequest.dbClusterParameterGroupName()));
        }
        if ((vpcSecurityGroupIdsList = createDBClusterRequest.vpcSecurityGroupIds()) != null) {
            if (!vpcSecurityGroupIdsList.isEmpty()) {
                int vpcSecurityGroupIdsListIndex = 1;
                for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                    if (vpcSecurityGroupIdsListValue != null) {
                        request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString((String)vpcSecurityGroupIdsListValue));
                    }
                    ++vpcSecurityGroupIdsListIndex;
                }
            } else {
                request.addParameter("VpcSecurityGroupIds", "");
            }
        }
        if (createDBClusterRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)createDBClusterRequest.dbSubnetGroupName()));
        }
        if (createDBClusterRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)createDBClusterRequest.engine()));
        }
        if (createDBClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)createDBClusterRequest.engineVersion()));
        }
        if (createDBClusterRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)createDBClusterRequest.port()));
        }
        if (createDBClusterRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringUtils.fromString((String)createDBClusterRequest.masterUsername()));
        }
        if (createDBClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringUtils.fromString((String)createDBClusterRequest.masterUserPassword()));
        }
        if (createDBClusterRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)createDBClusterRequest.optionGroupName()));
        }
        if (createDBClusterRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)createDBClusterRequest.preferredBackupWindow()));
        }
        if (createDBClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringUtils.fromString((String)createDBClusterRequest.preferredMaintenanceWindow()));
        }
        if (createDBClusterRequest.replicationSourceIdentifier() != null) {
            request.addParameter("ReplicationSourceIdentifier", StringUtils.fromString((String)createDBClusterRequest.replicationSourceIdentifier()));
        }
        if ((tagsList = createDBClusterRequest.tags()) != null) {
            if (!tagsList.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : tagsList) {
                    void var6_12;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.Tag." + (int)var6_12 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createDBClusterRequest.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringUtils.fromBoolean((Boolean)createDBClusterRequest.storageEncrypted()));
        }
        if (createDBClusterRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createDBClusterRequest.kmsKeyId()));
        }
        if (createDBClusterRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringUtils.fromString((String)createDBClusterRequest.preSignedUrl()));
        }
        if (createDBClusterRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)createDBClusterRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

