/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PromoteReadReplicaRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, PromoteReadReplicaRequest> {
    private final String dbInstanceIdentifier;
    private final Integer backupRetentionPeriod;
    private final String preferredBackupWindow;

    private PromoteReadReplicaRequest(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionPeriod() == null ? 0 : this.backupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromoteReadReplicaRequest)) {
            return false;
        }
        PromoteReadReplicaRequest other = (PromoteReadReplicaRequest)((Object)obj);
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.backupRetentionPeriod() == null ^ this.backupRetentionPeriod() == null) {
            return false;
        }
        if (other.backupRetentionPeriod() != null && !other.backupRetentionPeriod().equals(this.backupRetentionPeriod())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        return other.preferredBackupWindow() == null || other.preferredBackupWindow().equals(this.preferredBackupWindow());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.backupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.backupRetentionPeriod()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.of(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "BackupRetentionPeriod": {
                return Optional.of(clazz.cast(this.backupRetentionPeriod()));
            }
            case "PreferredBackupWindow": {
                return Optional.of(clazz.cast(this.preferredBackupWindow()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Integer backupRetentionPeriod;
        private String preferredBackupWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(PromoteReadReplicaRequest model) {
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.preferredBackupWindow(model.preferredBackupWindow);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public PromoteReadReplicaRequest build() {
            return new PromoteReadReplicaRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, PromoteReadReplicaRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder preferredBackupWindow(String var1);
    }
}

