/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.services.rds.model.ApplyMethod;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Parameter
implements ToCopyableBuilder<Builder, Parameter> {
    private final String parameterName;
    private final String parameterValue;
    private final String description;
    private final String source;
    private final String applyType;
    private final String dataType;
    private final String allowedValues;
    private final Boolean isModifiable;
    private final String minimumEngineVersion;
    private final String applyMethod;

    private Parameter(BuilderImpl builder) {
        this.parameterName = builder.parameterName;
        this.parameterValue = builder.parameterValue;
        this.description = builder.description;
        this.source = builder.source;
        this.applyType = builder.applyType;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.applyMethod = builder.applyMethod;
    }

    public String parameterName() {
        return this.parameterName;
    }

    public String parameterValue() {
        return this.parameterValue;
    }

    public String description() {
        return this.description;
    }

    public String source() {
        return this.source;
    }

    public String applyType() {
        return this.applyType;
    }

    public String dataType() {
        return this.dataType;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public Boolean isModifiable() {
        return this.isModifiable;
    }

    public String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public ApplyMethod applyMethod() {
        return ApplyMethod.fromValue(this.applyMethod);
    }

    public String applyMethodString() {
        return this.applyMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterName() == null ? 0 : this.parameterName().hashCode());
        hashCode = 31 * hashCode + (this.parameterValue() == null ? 0 : this.parameterValue().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.source() == null ? 0 : this.source().hashCode());
        hashCode = 31 * hashCode + (this.applyType() == null ? 0 : this.applyType().hashCode());
        hashCode = 31 * hashCode + (this.dataType() == null ? 0 : this.dataType().hashCode());
        hashCode = 31 * hashCode + (this.allowedValues() == null ? 0 : this.allowedValues().hashCode());
        hashCode = 31 * hashCode + (this.isModifiable() == null ? 0 : this.isModifiable().hashCode());
        hashCode = 31 * hashCode + (this.minimumEngineVersion() == null ? 0 : this.minimumEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.applyMethodString() == null ? 0 : this.applyMethodString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (other.parameterName() == null ^ this.parameterName() == null) {
            return false;
        }
        if (other.parameterName() != null && !other.parameterName().equals(this.parameterName())) {
            return false;
        }
        if (other.parameterValue() == null ^ this.parameterValue() == null) {
            return false;
        }
        if (other.parameterValue() != null && !other.parameterValue().equals(this.parameterValue())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.source() == null ^ this.source() == null) {
            return false;
        }
        if (other.source() != null && !other.source().equals(this.source())) {
            return false;
        }
        if (other.applyType() == null ^ this.applyType() == null) {
            return false;
        }
        if (other.applyType() != null && !other.applyType().equals(this.applyType())) {
            return false;
        }
        if (other.dataType() == null ^ this.dataType() == null) {
            return false;
        }
        if (other.dataType() != null && !other.dataType().equals(this.dataType())) {
            return false;
        }
        if (other.allowedValues() == null ^ this.allowedValues() == null) {
            return false;
        }
        if (other.allowedValues() != null && !other.allowedValues().equals(this.allowedValues())) {
            return false;
        }
        if (other.isModifiable() == null ^ this.isModifiable() == null) {
            return false;
        }
        if (other.isModifiable() != null && !other.isModifiable().equals(this.isModifiable())) {
            return false;
        }
        if (other.minimumEngineVersion() == null ^ this.minimumEngineVersion() == null) {
            return false;
        }
        if (other.minimumEngineVersion() != null && !other.minimumEngineVersion().equals(this.minimumEngineVersion())) {
            return false;
        }
        if (other.applyMethodString() == null ^ this.applyMethodString() == null) {
            return false;
        }
        return other.applyMethodString() == null || other.applyMethodString().equals(this.applyMethodString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterName() != null) {
            sb.append("ParameterName: ").append(this.parameterName()).append(",");
        }
        if (this.parameterValue() != null) {
            sb.append("ParameterValue: ").append(this.parameterValue()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.source() != null) {
            sb.append("Source: ").append(this.source()).append(",");
        }
        if (this.applyType() != null) {
            sb.append("ApplyType: ").append(this.applyType()).append(",");
        }
        if (this.dataType() != null) {
            sb.append("DataType: ").append(this.dataType()).append(",");
        }
        if (this.allowedValues() != null) {
            sb.append("AllowedValues: ").append(this.allowedValues()).append(",");
        }
        if (this.isModifiable() != null) {
            sb.append("IsModifiable: ").append(this.isModifiable()).append(",");
        }
        if (this.minimumEngineVersion() != null) {
            sb.append("MinimumEngineVersion: ").append(this.minimumEngineVersion()).append(",");
        }
        if (this.applyMethodString() != null) {
            sb.append("ApplyMethod: ").append(this.applyMethodString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterName": {
                return Optional.of(clazz.cast(this.parameterName()));
            }
            case "ParameterValue": {
                return Optional.of(clazz.cast(this.parameterValue()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Source": {
                return Optional.of(clazz.cast(this.source()));
            }
            case "ApplyType": {
                return Optional.of(clazz.cast(this.applyType()));
            }
            case "DataType": {
                return Optional.of(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.of(clazz.cast(this.allowedValues()));
            }
            case "IsModifiable": {
                return Optional.of(clazz.cast(this.isModifiable()));
            }
            case "MinimumEngineVersion": {
                return Optional.of(clazz.cast(this.minimumEngineVersion()));
            }
            case "ApplyMethod": {
                return Optional.of(clazz.cast(this.applyMethodString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterName;
        private String parameterValue;
        private String description;
        private String source;
        private String applyType;
        private String dataType;
        private String allowedValues;
        private Boolean isModifiable;
        private String minimumEngineVersion;
        private String applyMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(Parameter model) {
            this.parameterName(model.parameterName);
            this.parameterValue(model.parameterValue);
            this.description(model.description);
            this.source(model.source);
            this.applyType(model.applyType);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.isModifiable(model.isModifiable);
            this.minimumEngineVersion(model.minimumEngineVersion);
            this.applyMethod(model.applyMethod);
        }

        public final String getParameterName() {
            return this.parameterName;
        }

        @Override
        public final Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public final void setParameterName(String parameterName) {
            this.parameterName = parameterName;
        }

        public final String getParameterValue() {
            return this.parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getSource() {
            return this.source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getApplyType() {
            return this.applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final Boolean getIsModifiable() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        public final String getApplyMethod() {
            return this.applyMethod;
        }

        @Override
        public final Builder applyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
            return this;
        }

        @Override
        public final Builder applyMethod(ApplyMethod applyMethod) {
            this.applyMethod(applyMethod.toString());
            return this;
        }

        public final void setApplyMethod(String applyMethod) {
            this.applyMethod = applyMethod;
        }

        public Parameter build() {
            return new Parameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Parameter> {
        public Builder parameterName(String var1);

        public Builder parameterValue(String var1);

        public Builder description(String var1);

        public Builder source(String var1);

        public Builder applyType(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder isModifiable(Boolean var1);

        public Builder minimumEngineVersion(String var1);

        public Builder applyMethod(String var1);

        public Builder applyMethod(ApplyMethod var1);
    }
}

