/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionSetting
implements ToCopyableBuilder<Builder, OptionSetting> {
    private final String name;
    private final String value;
    private final String defaultValue;
    private final String description;
    private final String applyType;
    private final String dataType;
    private final String allowedValues;
    private final Boolean isModifiable;
    private final Boolean isCollection;

    private OptionSetting(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.applyType = builder.applyType;
        this.dataType = builder.dataType;
        this.allowedValues = builder.allowedValues;
        this.isModifiable = builder.isModifiable;
        this.isCollection = builder.isCollection;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String description() {
        return this.description;
    }

    public String applyType() {
        return this.applyType;
    }

    public String dataType() {
        return this.dataType;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public Boolean isModifiable() {
        return this.isModifiable;
    }

    public Boolean isCollection() {
        return this.isCollection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.defaultValue() == null ? 0 : this.defaultValue().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.applyType() == null ? 0 : this.applyType().hashCode());
        hashCode = 31 * hashCode + (this.dataType() == null ? 0 : this.dataType().hashCode());
        hashCode = 31 * hashCode + (this.allowedValues() == null ? 0 : this.allowedValues().hashCode());
        hashCode = 31 * hashCode + (this.isModifiable() == null ? 0 : this.isModifiable().hashCode());
        hashCode = 31 * hashCode + (this.isCollection() == null ? 0 : this.isCollection().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionSetting)) {
            return false;
        }
        OptionSetting other = (OptionSetting)obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        if (other.defaultValue() != null && !other.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.applyType() == null ^ this.applyType() == null) {
            return false;
        }
        if (other.applyType() != null && !other.applyType().equals(this.applyType())) {
            return false;
        }
        if (other.dataType() == null ^ this.dataType() == null) {
            return false;
        }
        if (other.dataType() != null && !other.dataType().equals(this.dataType())) {
            return false;
        }
        if (other.allowedValues() == null ^ this.allowedValues() == null) {
            return false;
        }
        if (other.allowedValues() != null && !other.allowedValues().equals(this.allowedValues())) {
            return false;
        }
        if (other.isModifiable() == null ^ this.isModifiable() == null) {
            return false;
        }
        if (other.isModifiable() != null && !other.isModifiable().equals(this.isModifiable())) {
            return false;
        }
        if (other.isCollection() == null ^ this.isCollection() == null) {
            return false;
        }
        return other.isCollection() == null || other.isCollection().equals(this.isCollection());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.applyType() != null) {
            sb.append("ApplyType: ").append(this.applyType()).append(",");
        }
        if (this.dataType() != null) {
            sb.append("DataType: ").append(this.dataType()).append(",");
        }
        if (this.allowedValues() != null) {
            sb.append("AllowedValues: ").append(this.allowedValues()).append(",");
        }
        if (this.isModifiable() != null) {
            sb.append("IsModifiable: ").append(this.isModifiable()).append(",");
        }
        if (this.isCollection() != null) {
            sb.append("IsCollection: ").append(this.isCollection()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "DefaultValue": {
                return Optional.of(clazz.cast(this.defaultValue()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ApplyType": {
                return Optional.of(clazz.cast(this.applyType()));
            }
            case "DataType": {
                return Optional.of(clazz.cast(this.dataType()));
            }
            case "AllowedValues": {
                return Optional.of(clazz.cast(this.allowedValues()));
            }
            case "IsModifiable": {
                return Optional.of(clazz.cast(this.isModifiable()));
            }
            case "IsCollection": {
                return Optional.of(clazz.cast(this.isCollection()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String value;
        private String defaultValue;
        private String description;
        private String applyType;
        private String dataType;
        private String allowedValues;
        private Boolean isModifiable;
        private Boolean isCollection;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionSetting model) {
            this.name(model.name);
            this.value(model.value);
            this.defaultValue(model.defaultValue);
            this.description(model.description);
            this.applyType(model.applyType);
            this.dataType(model.dataType);
            this.allowedValues(model.allowedValues);
            this.isModifiable(model.isModifiable);
            this.isCollection(model.isCollection);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getApplyType() {
            return this.applyType;
        }

        @Override
        public final Builder applyType(String applyType) {
            this.applyType = applyType;
            return this;
        }

        public final void setApplyType(String applyType) {
            this.applyType = applyType;
        }

        public final String getDataType() {
            return this.dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public final Boolean getIsModifiable() {
            return this.isModifiable;
        }

        @Override
        public final Builder isModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
            return this;
        }

        public final void setIsModifiable(Boolean isModifiable) {
            this.isModifiable = isModifiable;
        }

        public final Boolean getIsCollection() {
            return this.isCollection;
        }

        @Override
        public final Builder isCollection(Boolean isCollection) {
            this.isCollection = isCollection;
            return this;
        }

        public final void setIsCollection(Boolean isCollection) {
            this.isCollection = isCollection;
        }

        public OptionSetting build() {
            return new OptionSetting(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionSetting> {
        public Builder name(String var1);

        public Builder value(String var1);

        public Builder defaultValue(String var1);

        public Builder description(String var1);

        public Builder applyType(String var1);

        public Builder dataType(String var1);

        public Builder allowedValues(String var1);

        public Builder isModifiable(Boolean var1);

        public Builder isCollection(Boolean var1);
    }
}

