/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyDBParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ModifyDBParameterGroupRequest> {
    private final String dbParameterGroupName;
    private final List<Parameter> parameters;

    private ModifyDBParameterGroupRequest(BuilderImpl builder) {
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.parameters = builder.parameters;
    }

    public String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbParameterGroupName() == null ? 0 : this.dbParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBParameterGroupRequest)) {
            return false;
        }
        ModifyDBParameterGroupRequest other = (ModifyDBParameterGroupRequest)((Object)obj);
        if (other.dbParameterGroupName() == null ^ this.dbParameterGroupName() == null) {
            return false;
        }
        if (other.dbParameterGroupName() != null && !other.dbParameterGroupName().equals(this.dbParameterGroupName())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dbParameterGroupName() != null) {
            sb.append("DBParameterGroupName: ").append(this.dbParameterGroupName()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBParameterGroupName": {
                return Optional.of(clazz.cast(this.dbParameterGroupName()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbParameterGroupName;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDBParameterGroupRequest model) {
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.parameters(model.parameters);
        }

        public final String getDBParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDBParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        public ModifyDBParameterGroupRequest build() {
            return new ModifyDBParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ModifyDBParameterGroupRequest> {
        public Builder dbParameterGroupName(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

