/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;
import software.amazon.awssdk.services.rds.model.ReservedDBInstanceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedDBInstancesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedDBInstancesResponse> {
    private final String marker;
    private final List<ReservedDBInstance> reservedDBInstances;

    private DescribeReservedDBInstancesResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.reservedDBInstances = builder.reservedDBInstances;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedDBInstance> reservedDBInstances() {
        return this.reservedDBInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.reservedDBInstances() == null ? 0 : this.reservedDBInstances().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDBInstancesResponse)) {
            return false;
        }
        DescribeReservedDBInstancesResponse other = (DescribeReservedDBInstancesResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.reservedDBInstances() == null ^ this.reservedDBInstances() == null) {
            return false;
        }
        return other.reservedDBInstances() == null || other.reservedDBInstances().equals(this.reservedDBInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.reservedDBInstances() != null) {
            sb.append("ReservedDBInstances: ").append(this.reservedDBInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ReservedDBInstances": {
                return Optional.of(clazz.cast(this.reservedDBInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedDBInstance> reservedDBInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDBInstancesResponse model) {
            this.marker(model.marker);
            this.reservedDBInstances(model.reservedDBInstances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedDBInstance.Builder> getReservedDBInstances() {
            return this.reservedDBInstances != null ? (Collection)this.reservedDBInstances.stream().map(ReservedDBInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedDBInstances(Collection<ReservedDBInstance> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copy(reservedDBInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstances(ReservedDBInstance ... reservedDBInstances) {
            this.reservedDBInstances(Arrays.asList(reservedDBInstances));
            return this;
        }

        public final void setReservedDBInstances(Collection<ReservedDBInstance.BuilderImpl> reservedDBInstances) {
            this.reservedDBInstances = ReservedDBInstanceListCopier.copyFromBuilder(reservedDBInstances);
        }

        public DescribeReservedDBInstancesResponse build() {
            return new DescribeReservedDBInstancesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedDBInstancesResponse> {
        public Builder marker(String var1);

        public Builder reservedDBInstances(Collection<ReservedDBInstance> var1);

        public Builder reservedDBInstances(ReservedDBInstance ... var1);
    }
}

