/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshot;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshotListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBClusterSnapshotsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBClusterSnapshotsResponse> {
    private final String marker;
    private final List<DBClusterSnapshot> dbClusterSnapshots;

    private DescribeDBClusterSnapshotsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbClusterSnapshots = builder.dbClusterSnapshots;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBClusterSnapshot> dbClusterSnapshots() {
        return this.dbClusterSnapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterSnapshots() == null ? 0 : this.dbClusterSnapshots().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBClusterSnapshotsResponse)) {
            return false;
        }
        DescribeDBClusterSnapshotsResponse other = (DescribeDBClusterSnapshotsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbClusterSnapshots() == null ^ this.dbClusterSnapshots() == null) {
            return false;
        }
        return other.dbClusterSnapshots() == null || other.dbClusterSnapshots().equals(this.dbClusterSnapshots());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbClusterSnapshots() != null) {
            sb.append("DBClusterSnapshots: ").append(this.dbClusterSnapshots()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "DBClusterSnapshots": {
                return Optional.of(clazz.cast(this.dbClusterSnapshots()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterSnapshot> dbClusterSnapshots;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBClusterSnapshotsResponse model) {
            this.marker(model.marker);
            this.dbClusterSnapshots(model.dbClusterSnapshots);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterSnapshot.Builder> getDBClusterSnapshots() {
            return this.dbClusterSnapshots != null ? (Collection)this.dbClusterSnapshots.stream().map(DBClusterSnapshot::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterSnapshots(Collection<DBClusterSnapshot> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copy(dbClusterSnapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterSnapshots(DBClusterSnapshot ... dbClusterSnapshots) {
            this.dbClusterSnapshots(Arrays.asList(dbClusterSnapshots));
            return this;
        }

        public final void setDBClusterSnapshots(Collection<DBClusterSnapshot.BuilderImpl> dbClusterSnapshots) {
            this.dbClusterSnapshots = DBClusterSnapshotListCopier.copyFromBuilder(dbClusterSnapshots);
        }

        public DescribeDBClusterSnapshotsResponse build() {
            return new DescribeDBClusterSnapshotsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBClusterSnapshotsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterSnapshots(Collection<DBClusterSnapshot> var1);

        public Builder dbClusterSnapshots(DBClusterSnapshot ... var1);
    }
}

