/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest;
import software.amazon.awssdk.util.StringUtils;

public class PromoteReadReplicaRequestMarshaller
implements Marshaller<Request<PromoteReadReplicaRequest>, PromoteReadReplicaRequest> {
    public Request<PromoteReadReplicaRequest> marshall(PromoteReadReplicaRequest promoteReadReplicaRequest) {
        if (promoteReadReplicaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)promoteReadReplicaRequest, "RDSClient");
        request.addParameter("Action", "PromoteReadReplica");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (promoteReadReplicaRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)promoteReadReplicaRequest.dbInstanceIdentifier()));
        }
        if (promoteReadReplicaRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringUtils.fromInteger((Integer)promoteReadReplicaRequest.backupRetentionPeriod()));
        }
        if (promoteReadReplicaRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringUtils.fromString((String)promoteReadReplicaRequest.preferredBackupWindow()));
        }
        return request;
    }
}

