/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyDBClusterParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopyDBClusterParameterGroupRequest> {
    private final String sourceDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupIdentifier;
    private final String targetDBClusterParameterGroupDescription;
    private final List<Tag> tags;

    private CopyDBClusterParameterGroupRequest(BuilderImpl builder) {
        this.sourceDBClusterParameterGroupIdentifier = builder.sourceDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupIdentifier = builder.targetDBClusterParameterGroupIdentifier;
        this.targetDBClusterParameterGroupDescription = builder.targetDBClusterParameterGroupDescription;
        this.tags = builder.tags;
    }

    public String sourceDBClusterParameterGroupIdentifier() {
        return this.sourceDBClusterParameterGroupIdentifier;
    }

    public String targetDBClusterParameterGroupIdentifier() {
        return this.targetDBClusterParameterGroupIdentifier;
    }

    public String targetDBClusterParameterGroupDescription() {
        return this.targetDBClusterParameterGroupDescription;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceDBClusterParameterGroupIdentifier() == null ? 0 : this.sourceDBClusterParameterGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.targetDBClusterParameterGroupIdentifier() == null ? 0 : this.targetDBClusterParameterGroupIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.targetDBClusterParameterGroupDescription() == null ? 0 : this.targetDBClusterParameterGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDBClusterParameterGroupRequest)) {
            return false;
        }
        CopyDBClusterParameterGroupRequest other = (CopyDBClusterParameterGroupRequest)((Object)obj);
        if (other.sourceDBClusterParameterGroupIdentifier() == null ^ this.sourceDBClusterParameterGroupIdentifier() == null) {
            return false;
        }
        if (other.sourceDBClusterParameterGroupIdentifier() != null && !other.sourceDBClusterParameterGroupIdentifier().equals(this.sourceDBClusterParameterGroupIdentifier())) {
            return false;
        }
        if (other.targetDBClusterParameterGroupIdentifier() == null ^ this.targetDBClusterParameterGroupIdentifier() == null) {
            return false;
        }
        if (other.targetDBClusterParameterGroupIdentifier() != null && !other.targetDBClusterParameterGroupIdentifier().equals(this.targetDBClusterParameterGroupIdentifier())) {
            return false;
        }
        if (other.targetDBClusterParameterGroupDescription() == null ^ this.targetDBClusterParameterGroupDescription() == null) {
            return false;
        }
        if (other.targetDBClusterParameterGroupDescription() != null && !other.targetDBClusterParameterGroupDescription().equals(this.targetDBClusterParameterGroupDescription())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceDBClusterParameterGroupIdentifier() != null) {
            sb.append("SourceDBClusterParameterGroupIdentifier: ").append(this.sourceDBClusterParameterGroupIdentifier()).append(",");
        }
        if (this.targetDBClusterParameterGroupIdentifier() != null) {
            sb.append("TargetDBClusterParameterGroupIdentifier: ").append(this.targetDBClusterParameterGroupIdentifier()).append(",");
        }
        if (this.targetDBClusterParameterGroupDescription() != null) {
            sb.append("TargetDBClusterParameterGroupDescription: ").append(this.targetDBClusterParameterGroupDescription()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupIdentifier;
        private String targetDBClusterParameterGroupDescription;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDBClusterParameterGroupRequest model) {
            this.setSourceDBClusterParameterGroupIdentifier(model.sourceDBClusterParameterGroupIdentifier);
            this.setTargetDBClusterParameterGroupIdentifier(model.targetDBClusterParameterGroupIdentifier);
            this.setTargetDBClusterParameterGroupDescription(model.targetDBClusterParameterGroupDescription);
            this.setTags(model.tags);
        }

        public final String getSourceDBClusterParameterGroupIdentifier() {
            return this.sourceDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder sourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setSourceDBClusterParameterGroupIdentifier(String sourceDBClusterParameterGroupIdentifier) {
            this.sourceDBClusterParameterGroupIdentifier = sourceDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupIdentifier() {
            return this.targetDBClusterParameterGroupIdentifier;
        }

        @Override
        public final Builder targetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
            return this;
        }

        public final void setTargetDBClusterParameterGroupIdentifier(String targetDBClusterParameterGroupIdentifier) {
            this.targetDBClusterParameterGroupIdentifier = targetDBClusterParameterGroupIdentifier;
        }

        public final String getTargetDBClusterParameterGroupDescription() {
            return this.targetDBClusterParameterGroupDescription;
        }

        @Override
        public final Builder targetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
            return this;
        }

        public final void setTargetDBClusterParameterGroupDescription(String targetDBClusterParameterGroupDescription) {
            this.targetDBClusterParameterGroupDescription = targetDBClusterParameterGroupDescription;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        public CopyDBClusterParameterGroupRequest build() {
            return new CopyDBClusterParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyDBClusterParameterGroupRequest> {
        public Builder sourceDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupIdentifier(String var1);

        public Builder targetDBClusterParameterGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

