/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddSourceIdentifierToSubscriptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AddSourceIdentifierToSubscriptionRequest> {
    private final String subscriptionName;
    private final String sourceIdentifier;

    private AddSourceIdentifierToSubscriptionRequest(BuilderImpl builder) {
        this.subscriptionName = builder.subscriptionName;
        this.sourceIdentifier = builder.sourceIdentifier;
    }

    public String subscriptionName() {
        return this.subscriptionName;
    }

    public String sourceIdentifier() {
        return this.sourceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.subscriptionName() == null ? 0 : this.subscriptionName().hashCode());
        hashCode = 31 * hashCode + (this.sourceIdentifier() == null ? 0 : this.sourceIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddSourceIdentifierToSubscriptionRequest)) {
            return false;
        }
        AddSourceIdentifierToSubscriptionRequest other = (AddSourceIdentifierToSubscriptionRequest)((Object)obj);
        if (other.subscriptionName() == null ^ this.subscriptionName() == null) {
            return false;
        }
        if (other.subscriptionName() != null && !other.subscriptionName().equals(this.subscriptionName())) {
            return false;
        }
        if (other.sourceIdentifier() == null ^ this.sourceIdentifier() == null) {
            return false;
        }
        return other.sourceIdentifier() == null || other.sourceIdentifier().equals(this.sourceIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.subscriptionName() != null) {
            sb.append("SubscriptionName: ").append(this.subscriptionName()).append(",");
        }
        if (this.sourceIdentifier() != null) {
            sb.append("SourceIdentifier: ").append(this.sourceIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String subscriptionName;
        private String sourceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AddSourceIdentifierToSubscriptionRequest model) {
            this.setSubscriptionName(model.subscriptionName);
            this.setSourceIdentifier(model.sourceIdentifier);
        }

        public final String getSubscriptionName() {
            return this.subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final String getSourceIdentifier() {
            return this.sourceIdentifier;
        }

        @Override
        public final Builder sourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
            return this;
        }

        public final void setSourceIdentifier(String sourceIdentifier) {
            this.sourceIdentifier = sourceIdentifier;
        }

        public AddSourceIdentifierToSubscriptionRequest build() {
            return new AddSourceIdentifierToSubscriptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AddSourceIdentifierToSubscriptionRequest> {
        public Builder subscriptionName(String var1);

        public Builder sourceIdentifier(String var1);
    }
}

