/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.waiters;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DescribeDBInstancesRequest;
import software.amazon.awssdk.services.rds.waiters.DBInstanceAvailable;
import software.amazon.awssdk.services.rds.waiters.DBInstanceDeleted;
import software.amazon.awssdk.services.rds.waiters.DescribeDBInstancesFunction;
import software.amazon.awssdk.waiters.FixedDelayStrategy;
import software.amazon.awssdk.waiters.MaxAttemptsRetryStrategy;
import software.amazon.awssdk.waiters.PollingStrategy;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.waiters.Waiter;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterBuilder;

public class RDSClientWaiters {
    private final RDSClient client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public RDSClientWaiters(RDSClient client) {
        this.client = client;
    }

    public Waiter<DescribeDBInstancesRequest> dbInstanceAvailable() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDBInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DBInstanceAvailable.IsAvailableMatcher(), new DBInstanceAvailable.IsDeletedMatcher(), new DBInstanceAvailable.IsDeletingMatcher(), new DBInstanceAvailable.IsFailedMatcher(), new DBInstanceAvailable.IsIncompatiblerestoreMatcher(), new DBInstanceAvailable.IsIncompatibleparametersMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBInstancesRequest> dbInstanceDeleted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeDBInstancesFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new DBInstanceDeleted.IsDeletedMatcher(), new DBInstanceDeleted.IsDBInstanceNotFoundMatcher(), new DBInstanceDeleted.IsCreatingMatcher(), new DBInstanceDeleted.IsModifyingMatcher(), new DBInstanceDeleted.IsRebootingMatcher(), new DBInstanceDeleted.IsResettingmastercredentialsMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(60), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

