/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.OptionVersion;

public class OptionVersionUnmarshaller
implements Unmarshaller<OptionVersion, StaxUnmarshallerContext> {
    private static final OptionVersionUnmarshaller INSTANCE = new OptionVersionUnmarshaller();

    public OptionVersion unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        OptionVersion.Builder optionVersion = OptionVersion.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Version", targetDepth)) {
                    optionVersion.version(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("IsDefault", targetDepth)) continue;
                optionVersion.isDefault(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (OptionVersion)optionVersion.build();
    }

    public static OptionVersionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

