/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.Option;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.transform.DBSecurityGroupMembershipUnmarshaller;
import software.amazon.awssdk.services.rds.transform.OptionSettingUnmarshaller;
import software.amazon.awssdk.services.rds.transform.VpcSecurityGroupMembershipUnmarshaller;

public class OptionUnmarshaller
implements Unmarshaller<Option, StaxUnmarshallerContext> {
    private static final OptionUnmarshaller INSTANCE = new OptionUnmarshaller();

    public Option unmarshall(StaxUnmarshallerContext context) throws Exception {
        Option.Builder option;
        block15: {
            option = Option.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<OptionSetting> optionSettings = null;
            ArrayList<DBSecurityGroupMembership> dbSecurityGroupMemberships = null;
            ArrayList<VpcSecurityGroupMembership> vpcSecurityGroupMemberships = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    option.optionSettings(optionSettings);
                    option.dbSecurityGroupMemberships(dbSecurityGroupMemberships);
                    option.vpcSecurityGroupMemberships(vpcSecurityGroupMemberships);
                    break block15;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("OptionName", targetDepth)) {
                        option.optionName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OptionDescription", targetDepth)) {
                        option.optionDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Persistent", targetDepth)) {
                        option.persistent(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Permanent", targetDepth)) {
                        option.permanent(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Port", targetDepth)) {
                        option.port(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OptionVersion", targetDepth)) {
                        option.optionVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("OptionSettings", targetDepth)) {
                        optionSettings = new ArrayList<OptionSetting>();
                        continue;
                    }
                    if (context.testExpression("OptionSettings/OptionSetting", targetDepth)) {
                        optionSettings.add(OptionSettingUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBSecurityGroupMemberships", targetDepth)) {
                        dbSecurityGroupMemberships = new ArrayList<DBSecurityGroupMembership>();
                        continue;
                    }
                    if (context.testExpression("DBSecurityGroupMemberships/DBSecurityGroup", targetDepth)) {
                        dbSecurityGroupMemberships.add(DBSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("VpcSecurityGroupMemberships", targetDepth)) {
                        vpcSecurityGroupMemberships = new ArrayList<VpcSecurityGroupMembership>();
                        continue;
                    }
                    if (!context.testExpression("VpcSecurityGroupMemberships/VpcSecurityGroupMembership", targetDepth)) continue;
                    vpcSecurityGroupMemberships.add(VpcSecurityGroupMembershipUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            option.optionSettings(optionSettings);
            option.dbSecurityGroupMemberships(dbSecurityGroupMemberships);
            option.vpcSecurityGroupMemberships(vpcSecurityGroupMemberships);
        }
        return (Option)option.build();
    }

    public static OptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

