/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.EngineDefaults;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.transform.ParameterUnmarshaller;

public class EngineDefaultsUnmarshaller
implements Unmarshaller<EngineDefaults, StaxUnmarshallerContext> {
    private static final EngineDefaultsUnmarshaller INSTANCE = new EngineDefaultsUnmarshaller();

    public EngineDefaults unmarshall(StaxUnmarshallerContext context) throws Exception {
        EngineDefaults.Builder engineDefaults;
        block7: {
            engineDefaults = EngineDefaults.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<Parameter> parameters = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    engineDefaults.parameters(parameters);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("DBParameterGroupFamily", targetDepth)) {
                        engineDefaults.dbParameterGroupFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Marker", targetDepth)) {
                        engineDefaults.marker(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Parameters", targetDepth)) {
                        parameters = new ArrayList<Parameter>();
                        continue;
                    }
                    if (!context.testExpression("Parameters/Parameter", targetDepth)) continue;
                    parameters.add(ParameterUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            engineDefaults.parameters(parameters);
        }
        return (EngineDefaults)engineDefaults.build();
    }

    public static EngineDefaultsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

