/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeDBSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDBSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeDBSnapshotsRequest>, DescribeDBSnapshotsRequest> {
    public Request<DescribeDBSnapshotsRequest> marshall(DescribeDBSnapshotsRequest describeDBSnapshotsRequest) {
        List<Filter> filtersList;
        if (describeDBSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBSnapshotsRequest, "RDSClient");
        request.addParameter("Action", "DescribeDBSnapshots");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBSnapshotsRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)describeDBSnapshotsRequest.dbInstanceIdentifier()));
        }
        if (describeDBSnapshotsRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString((String)describeDBSnapshotsRequest.dbSnapshotIdentifier()));
        }
        if (describeDBSnapshotsRequest.snapshotType() != null) {
            request.addParameter("SnapshotType", StringUtils.fromString((String)describeDBSnapshotsRequest.snapshotType()));
        }
        if ((filtersList = describeDBSnapshotsRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeDBSnapshotsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBSnapshotsRequest.maxRecords()));
        }
        if (describeDBSnapshotsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBSnapshotsRequest.marker()));
        }
        if (describeDBSnapshotsRequest.includeShared() != null) {
            request.addParameter("IncludeShared", StringUtils.fromBoolean((Boolean)describeDBSnapshotsRequest.includeShared()));
        }
        if (describeDBSnapshotsRequest.includePublic() != null) {
            request.addParameter("IncludePublic", StringUtils.fromBoolean((Boolean)describeDBSnapshotsRequest.includePublic()));
        }
        return request;
    }
}

