/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.SourceRegion;
import software.amazon.awssdk.services.rds.model.SourceRegionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSourceRegionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeSourceRegionsResponse> {
    private final String marker;
    private final List<SourceRegion> sourceRegions;

    private DescribeSourceRegionsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.sourceRegions = builder.sourceRegions;
    }

    public String marker() {
        return this.marker;
    }

    public List<SourceRegion> sourceRegions() {
        return this.sourceRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.sourceRegions() == null ? 0 : this.sourceRegions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceRegionsResponse)) {
            return false;
        }
        DescribeSourceRegionsResponse other = (DescribeSourceRegionsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.sourceRegions() == null ^ this.sourceRegions() == null) {
            return false;
        }
        return other.sourceRegions() == null || other.sourceRegions().equals(this.sourceRegions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.sourceRegions() != null) {
            sb.append("SourceRegions: ").append(this.sourceRegions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<SourceRegion> sourceRegions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceRegionsResponse model) {
            this.setMarker(model.marker);
            this.setSourceRegions(model.sourceRegions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<SourceRegion> getSourceRegions() {
            return this.sourceRegions;
        }

        @Override
        public final Builder sourceRegions(Collection<SourceRegion> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copy(sourceRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceRegions(SourceRegion ... sourceRegions) {
            this.sourceRegions(Arrays.asList(sourceRegions));
            return this;
        }

        public final void setSourceRegions(Collection<SourceRegion> sourceRegions) {
            this.sourceRegions = SourceRegionListCopier.copy(sourceRegions);
        }

        public DescribeSourceRegionsResponse build() {
            return new DescribeSourceRegionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeSourceRegionsResponse> {
        public Builder marker(String var1);

        public Builder sourceRegions(Collection<SourceRegion> var1);

        public Builder sourceRegions(SourceRegion ... var1);
    }
}

