/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOffering;
import software.amazon.awssdk.services.rds.model.ReservedDBInstancesOfferingListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedDBInstancesOfferingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedDBInstancesOfferingsResponse> {
    private final String marker;
    private final List<ReservedDBInstancesOffering> reservedDBInstancesOfferings;

    private DescribeReservedDBInstancesOfferingsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.reservedDBInstancesOfferings = builder.reservedDBInstancesOfferings;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedDBInstancesOffering> reservedDBInstancesOfferings() {
        return this.reservedDBInstancesOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.reservedDBInstancesOfferings() == null ? 0 : this.reservedDBInstancesOfferings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedDBInstancesOfferingsResponse)) {
            return false;
        }
        DescribeReservedDBInstancesOfferingsResponse other = (DescribeReservedDBInstancesOfferingsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.reservedDBInstancesOfferings() == null ^ this.reservedDBInstancesOfferings() == null) {
            return false;
        }
        return other.reservedDBInstancesOfferings() == null || other.reservedDBInstancesOfferings().equals(this.reservedDBInstancesOfferings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.reservedDBInstancesOfferings() != null) {
            sb.append("ReservedDBInstancesOfferings: ").append(this.reservedDBInstancesOfferings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedDBInstancesOffering> reservedDBInstancesOfferings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedDBInstancesOfferingsResponse model) {
            this.setMarker(model.marker);
            this.setReservedDBInstancesOfferings(model.reservedDBInstancesOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedDBInstancesOffering> getReservedDBInstancesOfferings() {
            return this.reservedDBInstancesOfferings;
        }

        @Override
        public final Builder reservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering> reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings = ReservedDBInstancesOfferingListCopier.copy(reservedDBInstancesOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedDBInstancesOfferings(ReservedDBInstancesOffering ... reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings(Arrays.asList(reservedDBInstancesOfferings));
            return this;
        }

        public final void setReservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering> reservedDBInstancesOfferings) {
            this.reservedDBInstancesOfferings = ReservedDBInstancesOfferingListCopier.copy(reservedDBInstancesOfferings);
        }

        public DescribeReservedDBInstancesOfferingsResponse build() {
            return new DescribeReservedDBInstancesOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedDBInstancesOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedDBInstancesOfferings(Collection<ReservedDBInstancesOffering> var1);

        public Builder reservedDBInstancesOfferings(ReservedDBInstancesOffering ... var1);
    }
}

