/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DBSubnetGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBSubnetGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBSubnetGroupsResponse> {
    private final String marker;
    private final List<DBSubnetGroup> dbSubnetGroups;

    private DescribeDBSubnetGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbSubnetGroups = builder.dbSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBSubnetGroup> dbSubnetGroups() {
        return this.dbSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroups() == null ? 0 : this.dbSubnetGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBSubnetGroupsResponse)) {
            return false;
        }
        DescribeDBSubnetGroupsResponse other = (DescribeDBSubnetGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbSubnetGroups() == null ^ this.dbSubnetGroups() == null) {
            return false;
        }
        return other.dbSubnetGroups() == null || other.dbSubnetGroups().equals(this.dbSubnetGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbSubnetGroups() != null) {
            sb.append("DBSubnetGroups: ").append(this.dbSubnetGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSubnetGroup> dbSubnetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBSubnetGroupsResponse model) {
            this.setMarker(model.marker);
            this.setDBSubnetGroups(model.dbSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSubnetGroup> getDBSubnetGroups() {
            return this.dbSubnetGroups;
        }

        @Override
        public final Builder dbSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copy(dbSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(DBSubnetGroup ... dbSubnetGroups) {
            this.dbSubnetGroups(Arrays.asList(dbSubnetGroups));
            return this;
        }

        public final void setDBSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copy(dbSubnetGroups);
        }

        public DescribeDBSubnetGroupsResponse build() {
            return new DescribeDBSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbSubnetGroups(Collection<DBSubnetGroup> var1);

        public Builder dbSubnetGroups(DBSubnetGroup ... var1);
    }
}

