/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.rds.model.DBSecurityGroup;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBSecurityGroupsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDBSecurityGroupsResponse> {
    private final String marker;
    private final List<DBSecurityGroup> dbSecurityGroups;

    private DescribeDBSecurityGroupsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.dbSecurityGroups = builder.dbSecurityGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBSecurityGroup> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroups() == null ? 0 : this.dbSecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBSecurityGroupsResponse)) {
            return false;
        }
        DescribeDBSecurityGroupsResponse other = (DescribeDBSecurityGroupsResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.dbSecurityGroups() == null ^ this.dbSecurityGroups() == null) {
            return false;
        }
        return other.dbSecurityGroups() == null || other.dbSecurityGroups().equals(this.dbSecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.dbSecurityGroups() != null) {
            sb.append("DBSecurityGroups: ").append(this.dbSecurityGroups()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSecurityGroup> dbSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBSecurityGroupsResponse model) {
            this.setMarker(model.marker);
            this.setDBSecurityGroups(model.dbSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSecurityGroup> getDBSecurityGroups() {
            return this.dbSecurityGroups;
        }

        @Override
        public final Builder dbSecurityGroups(Collection<DBSecurityGroup> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(DBSecurityGroup ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final void setDBSecurityGroups(Collection<DBSecurityGroup> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupsCopier.copy(dbSecurityGroups);
        }

        public DescribeDBSecurityGroupsResponse build() {
            return new DescribeDBSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbSecurityGroups(Collection<DBSecurityGroup> var1);

        public Builder dbSecurityGroups(DBSecurityGroup ... var1);
    }
}

