/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.StopDBInstanceRequest;
import software.amazon.awssdk.util.StringUtils;

public class StopDBInstanceRequestMarshaller
implements Marshaller<Request<StopDBInstanceRequest>, StopDBInstanceRequest> {
    public Request<StopDBInstanceRequest> marshall(StopDBInstanceRequest stopDBInstanceRequest) {
        if (stopDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)stopDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "StopDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (stopDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)stopDBInstanceRequest.dbInstanceIdentifier()));
        }
        if (stopDBInstanceRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringUtils.fromString((String)stopDBInstanceRequest.dbSnapshotIdentifier()));
        }
        return request;
    }
}

