/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.util.StringUtils;

public class RemoveTagsFromResourceRequestMarshaller
implements Marshaller<Request<RemoveTagsFromResourceRequest>, RemoveTagsFromResourceRequest> {
    public Request<RemoveTagsFromResourceRequest> marshall(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        List<String> tagKeysList;
        if (removeTagsFromResourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removeTagsFromResourceRequest, "RDSClient");
        request.addParameter("Action", "RemoveTagsFromResource");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeTagsFromResourceRequest.resourceName() != null) {
            request.addParameter("ResourceName", StringUtils.fromString((String)removeTagsFromResourceRequest.resourceName()));
        }
        if ((tagKeysList = removeTagsFromResourceRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKeys.member." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKeys", "");
            }
        }
        return request;
    }
}

