/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.AvailabilityZone;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption;
import software.amazon.awssdk.services.rds.transform.AvailabilityZoneUnmarshaller;

public class OrderableDBInstanceOptionUnmarshaller
implements Unmarshaller<OrderableDBInstanceOption, StaxUnmarshallerContext> {
    private static OrderableDBInstanceOptionUnmarshaller INSTANCE;

    public OrderableDBInstanceOption unmarshall(StaxUnmarshallerContext context) throws Exception {
        OrderableDBInstanceOption.Builder orderableDBInstanceOption;
        block17: {
            orderableDBInstanceOption = OrderableDBInstanceOption.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<AvailabilityZone> availabilityZones = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    orderableDBInstanceOption.availabilityZones(availabilityZones);
                    break block17;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Engine", targetDepth)) {
                        orderableDBInstanceOption.engine(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EngineVersion", targetDepth)) {
                        orderableDBInstanceOption.engineVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DBInstanceClass", targetDepth)) {
                        orderableDBInstanceOption.dbInstanceClass(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LicenseModel", targetDepth)) {
                        orderableDBInstanceOption.licenseModel(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones", targetDepth)) {
                        availabilityZones = new ArrayList<AvailabilityZone>();
                        continue;
                    }
                    if (context.testExpression("AvailabilityZones/AvailabilityZone", targetDepth)) {
                        availabilityZones.add(AvailabilityZoneUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MultiAZCapable", targetDepth)) {
                        orderableDBInstanceOption.multiAZCapable(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ReadReplicaCapable", targetDepth)) {
                        orderableDBInstanceOption.readReplicaCapable(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Vpc", targetDepth)) {
                        orderableDBInstanceOption.vpc(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SupportsStorageEncryption", targetDepth)) {
                        orderableDBInstanceOption.supportsStorageEncryption(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StorageType", targetDepth)) {
                        orderableDBInstanceOption.storageType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SupportsIops", targetDepth)) {
                        orderableDBInstanceOption.supportsIops(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SupportsEnhancedMonitoring", targetDepth)) {
                        orderableDBInstanceOption.supportsEnhancedMonitoring(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("SupportsIAMDatabaseAuthentication", targetDepth)) continue;
                    orderableDBInstanceOption.supportsIAMDatabaseAuthentication(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            orderableDBInstanceOption.availabilityZones(availabilityZones);
        }
        return (OrderableDBInstanceOption)orderableDBInstanceOption.build();
    }

    public static OrderableDBInstanceOptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OrderableDBInstanceOptionUnmarshaller();
        }
        return INSTANCE;
    }
}

