/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DescribeDBEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDBEngineVersionsRequestMarshaller
implements Marshaller<Request<DescribeDBEngineVersionsRequest>, DescribeDBEngineVersionsRequest> {
    public Request<DescribeDBEngineVersionsRequest> marshall(DescribeDBEngineVersionsRequest describeDBEngineVersionsRequest) {
        List<Filter> filtersList;
        if (describeDBEngineVersionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDBEngineVersionsRequest, "RDSClient");
        request.addParameter("Action", "DescribeDBEngineVersions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDBEngineVersionsRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)describeDBEngineVersionsRequest.engine()));
        }
        if (describeDBEngineVersionsRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString((String)describeDBEngineVersionsRequest.engineVersion()));
        }
        if (describeDBEngineVersionsRequest.dbParameterGroupFamily() != null) {
            request.addParameter("DBParameterGroupFamily", StringUtils.fromString((String)describeDBEngineVersionsRequest.dbParameterGroupFamily()));
        }
        if ((filtersList = describeDBEngineVersionsRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeDBEngineVersionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeDBEngineVersionsRequest.maxRecords()));
        }
        if (describeDBEngineVersionsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeDBEngineVersionsRequest.marker()));
        }
        if (describeDBEngineVersionsRequest.defaultOnly() != null) {
            request.addParameter("DefaultOnly", StringUtils.fromBoolean((Boolean)describeDBEngineVersionsRequest.defaultOnly()));
        }
        if (describeDBEngineVersionsRequest.listSupportedCharacterSets() != null) {
            request.addParameter("ListSupportedCharacterSets", StringUtils.fromBoolean((Boolean)describeDBEngineVersionsRequest.listSupportedCharacterSets()));
        }
        if (describeDBEngineVersionsRequest.listSupportedTimezones() != null) {
            request.addParameter("ListSupportedTimezones", StringUtils.fromBoolean((Boolean)describeDBEngineVersionsRequest.listSupportedTimezones()));
        }
        return request;
    }
}

