/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.DeleteDBInstanceRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteDBInstanceRequestMarshaller
implements Marshaller<Request<DeleteDBInstanceRequest>, DeleteDBInstanceRequest> {
    public Request<DeleteDBInstanceRequest> marshall(DeleteDBInstanceRequest deleteDBInstanceRequest) {
        if (deleteDBInstanceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteDBInstanceRequest, "RDSClient");
        request.addParameter("Action", "DeleteDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteDBInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringUtils.fromString((String)deleteDBInstanceRequest.dbInstanceIdentifier()));
        }
        if (deleteDBInstanceRequest.skipFinalSnapshot() != null) {
            request.addParameter("SkipFinalSnapshot", StringUtils.fromBoolean((Boolean)deleteDBInstanceRequest.skipFinalSnapshot()));
        }
        if (deleteDBInstanceRequest.finalDBSnapshotIdentifier() != null) {
            request.addParameter("FinalDBSnapshotIdentifier", StringUtils.fromString((String)deleteDBInstanceRequest.finalDBSnapshotIdentifier()));
        }
        return request;
    }
}

