/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopDBInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, StopDBInstanceRequest> {
    private final String dbInstanceIdentifier;
    private final String dbSnapshotIdentifier;

    private StopDBInstanceRequest(BuilderImpl builder) {
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbInstanceIdentifier() == null ? 0 : this.dbInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbSnapshotIdentifier() == null ? 0 : this.dbSnapshotIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopDBInstanceRequest)) {
            return false;
        }
        StopDBInstanceRequest other = (StopDBInstanceRequest)((Object)obj);
        if (other.dbInstanceIdentifier() == null ^ this.dbInstanceIdentifier() == null) {
            return false;
        }
        if (other.dbInstanceIdentifier() != null && !other.dbInstanceIdentifier().equals(this.dbInstanceIdentifier())) {
            return false;
        }
        if (other.dbSnapshotIdentifier() == null ^ this.dbSnapshotIdentifier() == null) {
            return false;
        }
        return other.dbSnapshotIdentifier() == null || other.dbSnapshotIdentifier().equals(this.dbSnapshotIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.dbInstanceIdentifier()).append(",");
        }
        if (this.dbSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: ").append(this.dbSnapshotIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private String dbSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(StopDBInstanceRequest model) {
            this.setDBInstanceIdentifier(model.dbInstanceIdentifier);
            this.setDBSnapshotIdentifier(model.dbSnapshotIdentifier);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public StopDBInstanceRequest build() {
            return new StopDBInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StopDBInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder dbSnapshotIdentifier(String var1);
    }
}

