/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceAction;
import software.amazon.awssdk.services.rds.model.PendingMaintenanceActionDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourcePendingMaintenanceActions
implements ToCopyableBuilder<Builder, ResourcePendingMaintenanceActions> {
    private final String resourceIdentifier;
    private final List<PendingMaintenanceAction> pendingMaintenanceActionDetails;

    private ResourcePendingMaintenanceActions(BuilderImpl builder) {
        this.resourceIdentifier = builder.resourceIdentifier;
        this.pendingMaintenanceActionDetails = builder.pendingMaintenanceActionDetails;
    }

    public String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public List<PendingMaintenanceAction> pendingMaintenanceActionDetails() {
        return this.pendingMaintenanceActionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.resourceIdentifier() == null ? 0 : this.resourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.pendingMaintenanceActionDetails() == null ? 0 : this.pendingMaintenanceActionDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcePendingMaintenanceActions)) {
            return false;
        }
        ResourcePendingMaintenanceActions other = (ResourcePendingMaintenanceActions)obj;
        if (other.resourceIdentifier() == null ^ this.resourceIdentifier() == null) {
            return false;
        }
        if (other.resourceIdentifier() != null && !other.resourceIdentifier().equals(this.resourceIdentifier())) {
            return false;
        }
        if (other.pendingMaintenanceActionDetails() == null ^ this.pendingMaintenanceActionDetails() == null) {
            return false;
        }
        return other.pendingMaintenanceActionDetails() == null || other.pendingMaintenanceActionDetails().equals(this.pendingMaintenanceActionDetails());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resourceIdentifier() != null) {
            sb.append("ResourceIdentifier: ").append(this.resourceIdentifier()).append(",");
        }
        if (this.pendingMaintenanceActionDetails() != null) {
            sb.append("PendingMaintenanceActionDetails: ").append(this.pendingMaintenanceActionDetails()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private List<PendingMaintenanceAction> pendingMaintenanceActionDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcePendingMaintenanceActions model) {
            this.setResourceIdentifier(model.resourceIdentifier);
            this.setPendingMaintenanceActionDetails(model.pendingMaintenanceActionDetails);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        public final Collection<PendingMaintenanceAction> getPendingMaintenanceActionDetails() {
            return this.pendingMaintenanceActionDetails;
        }

        @Override
        public final Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier.copy(pendingMaintenanceActionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingMaintenanceActionDetails(PendingMaintenanceAction ... pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails(Arrays.asList(pendingMaintenanceActionDetails));
            return this;
        }

        public final void setPendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails = PendingMaintenanceActionDetailsCopier.copy(pendingMaintenanceActionDetails);
        }

        @SafeVarargs
        public final void setPendingMaintenanceActionDetails(PendingMaintenanceAction ... pendingMaintenanceActionDetails) {
            this.pendingMaintenanceActionDetails(Arrays.asList(pendingMaintenanceActionDetails));
        }

        public ResourcePendingMaintenanceActions build() {
            return new ResourcePendingMaintenanceActions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourcePendingMaintenanceActions> {
        public Builder resourceIdentifier(String var1);

        public Builder pendingMaintenanceActionDetails(Collection<PendingMaintenanceAction> var1);

        public Builder pendingMaintenanceActionDetails(PendingMaintenanceAction ... var1);
    }
}

