/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class FailoverDBClusterRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, FailoverDBClusterRequest> {
    private final String dbClusterIdentifier;
    private final String targetDBInstanceIdentifier;

    private FailoverDBClusterRequest(BuilderImpl builder) {
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.targetDBInstanceIdentifier = builder.targetDBInstanceIdentifier;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String targetDBInstanceIdentifier() {
        return this.targetDBInstanceIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.targetDBInstanceIdentifier() == null ? 0 : this.targetDBInstanceIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailoverDBClusterRequest)) {
            return false;
        }
        FailoverDBClusterRequest other = (FailoverDBClusterRequest)((Object)obj);
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.targetDBInstanceIdentifier() == null ^ this.targetDBInstanceIdentifier() == null) {
            return false;
        }
        return other.targetDBInstanceIdentifier() == null || other.targetDBInstanceIdentifier().equals(this.targetDBInstanceIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.targetDBInstanceIdentifier() != null) {
            sb.append("TargetDBInstanceIdentifier: ").append(this.targetDBInstanceIdentifier()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbClusterIdentifier;
        private String targetDBInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(FailoverDBClusterRequest model) {
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setTargetDBInstanceIdentifier(model.targetDBInstanceIdentifier);
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getTargetDBInstanceIdentifier() {
            return this.targetDBInstanceIdentifier;
        }

        @Override
        public final Builder targetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
            return this;
        }

        public final void setTargetDBInstanceIdentifier(String targetDBInstanceIdentifier) {
            this.targetDBInstanceIdentifier = targetDBInstanceIdentifier;
        }

        public FailoverDBClusterRequest build() {
            return new FailoverDBClusterRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, FailoverDBClusterRequest> {
        public Builder dbClusterIdentifier(String var1);

        public Builder targetDBInstanceIdentifier(String var1);
    }
}

