/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEventCategoriesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeEventCategoriesRequest> {
    private final String sourceType;
    private final List<Filter> filters;

    private DescribeEventCategoriesRequest(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.filters = builder.filters;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceType() == null ? 0 : this.sourceType().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventCategoriesRequest)) {
            return false;
        }
        DescribeEventCategoriesRequest other = (DescribeEventCategoriesRequest)((Object)obj);
        if (other.sourceType() == null ^ this.sourceType() == null) {
            return false;
        }
        if (other.sourceType() != null && !other.sourceType().equals(this.sourceType())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        return other.filters() == null || other.filters().equals(this.filters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private List<Filter> filters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventCategoriesRequest model) {
            this.setSourceType(model.sourceType);
            this.setFilters(model.filters);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public DescribeEventCategoriesRequest build() {
            return new DescribeEventCategoriesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEventCategoriesRequest> {
        public Builder sourceType(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);
    }
}

