/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.rds.model.Filter;
import software.amazon.awssdk.services.rds.model.FilterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDBSecurityGroupsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeDBSecurityGroupsRequest> {
    private final String dbSecurityGroupName;
    private final List<Filter> filters;
    private final Integer maxRecords;
    private final String marker;

    private DescribeDBSecurityGroupsRequest(BuilderImpl builder) {
        this.dbSecurityGroupName = builder.dbSecurityGroupName;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String dbSecurityGroupName() {
        return this.dbSecurityGroupName;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbSecurityGroupName() == null ? 0 : this.dbSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.filters() == null ? 0 : this.filters().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDBSecurityGroupsRequest)) {
            return false;
        }
        DescribeDBSecurityGroupsRequest other = (DescribeDBSecurityGroupsRequest)((Object)obj);
        if (other.dbSecurityGroupName() == null ^ this.dbSecurityGroupName() == null) {
            return false;
        }
        if (other.dbSecurityGroupName() != null && !other.dbSecurityGroupName().equals(this.dbSecurityGroupName())) {
            return false;
        }
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbSecurityGroupName() != null) {
            sb.append("DBSecurityGroupName: ").append(this.dbSecurityGroupName()).append(",");
        }
        if (this.filters() != null) {
            sb.append("Filters: ").append(this.filters()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbSecurityGroupName;
        private List<Filter> filters;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDBSecurityGroupsRequest model) {
            this.setDBSecurityGroupName(model.dbSecurityGroupName);
            this.setFilters(model.filters);
            this.setMaxRecords(model.maxRecords);
            this.setMarker(model.marker);
        }

        public final String getDBSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        @Override
        public final Builder dbSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        public final void setDBSecurityGroupName(String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
        }

        public final Collection<Filter> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeDBSecurityGroupsRequest build() {
            return new DescribeDBSecurityGroupsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDBSecurityGroupsRequest> {
        public Builder dbSecurityGroupName(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

