/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ModifyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.OptionConfiguration;
import software.amazon.awssdk.services.rds.model.OptionSetting;

public class ModifyOptionGroupRequestMarshaller
implements Marshaller<Request<ModifyOptionGroupRequest>, ModifyOptionGroupRequest> {
    public Request<ModifyOptionGroupRequest> marshall(ModifyOptionGroupRequest modifyOptionGroupRequest) {
        if (modifyOptionGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyOptionGroupRequest, "RdsClient");
        request.addParameter("Action", "ModifyOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyOptionGroupRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)modifyOptionGroupRequest.optionGroupName()));
        }
        if (modifyOptionGroupRequest.optionsToInclude().isEmpty() && !(modifyOptionGroupRequest.optionsToInclude() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionsToInclude", "");
        } else if (!modifyOptionGroupRequest.optionsToInclude().isEmpty() && !(modifyOptionGroupRequest.optionsToInclude() instanceof SdkAutoConstructList)) {
            List<OptionConfiguration> optionsToIncludeList = modifyOptionGroupRequest.optionsToInclude();
            int optionsToIncludeListIndex = 1;
            for (OptionConfiguration optionsToIncludeListValue : optionsToIncludeList) {
                if (optionsToIncludeListValue.optionName() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionName", StringConversion.fromString((String)optionsToIncludeListValue.optionName()));
                }
                if (optionsToIncludeListValue.port() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".Port", StringConversion.fromInteger((Integer)optionsToIncludeListValue.port()));
                }
                if (optionsToIncludeListValue.optionVersion() != null) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionVersion", StringConversion.fromString((String)optionsToIncludeListValue.optionVersion()));
                }
                if (optionsToIncludeListValue.dbSecurityGroupMemberships().isEmpty() && !(optionsToIncludeListValue.dbSecurityGroupMemberships() instanceof SdkAutoConstructList)) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".DBSecurityGroupMemberships", "");
                } else if (!optionsToIncludeListValue.dbSecurityGroupMemberships().isEmpty() && !(optionsToIncludeListValue.dbSecurityGroupMemberships() instanceof SdkAutoConstructList)) {
                    List<String> dBSecurityGroupMembershipsList = optionsToIncludeListValue.dbSecurityGroupMemberships();
                    int dBSecurityGroupMembershipsListIndex = 1;
                    for (String dBSecurityGroupMembershipsListValue : dBSecurityGroupMembershipsList) {
                        if (dBSecurityGroupMembershipsListValue != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".DBSecurityGroupMemberships.DBSecurityGroupName." + dBSecurityGroupMembershipsListIndex, StringConversion.fromString((String)dBSecurityGroupMembershipsListValue));
                        }
                        ++dBSecurityGroupMembershipsListIndex;
                    }
                }
                if (optionsToIncludeListValue.vpcSecurityGroupMemberships().isEmpty() && !(optionsToIncludeListValue.vpcSecurityGroupMemberships() instanceof SdkAutoConstructList)) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".VpcSecurityGroupMemberships", "");
                } else if (!optionsToIncludeListValue.vpcSecurityGroupMemberships().isEmpty() && !(optionsToIncludeListValue.vpcSecurityGroupMemberships() instanceof SdkAutoConstructList)) {
                    List<String> vpcSecurityGroupMembershipsList = optionsToIncludeListValue.vpcSecurityGroupMemberships();
                    int vpcSecurityGroupMembershipsListIndex = 1;
                    for (String vpcSecurityGroupMembershipsListValue : vpcSecurityGroupMembershipsList) {
                        if (vpcSecurityGroupMembershipsListValue != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".VpcSecurityGroupMemberships.VpcSecurityGroupId." + vpcSecurityGroupMembershipsListIndex, StringConversion.fromString((String)vpcSecurityGroupMembershipsListValue));
                        }
                        ++vpcSecurityGroupMembershipsListIndex;
                    }
                }
                if (optionsToIncludeListValue.optionSettings().isEmpty() && !(optionsToIncludeListValue.optionSettings() instanceof SdkAutoConstructList)) {
                    request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings", "");
                } else if (!optionsToIncludeListValue.optionSettings().isEmpty() && !(optionsToIncludeListValue.optionSettings() instanceof SdkAutoConstructList)) {
                    List<OptionSetting> optionSettingsList = optionsToIncludeListValue.optionSettings();
                    int optionSettingsListIndex = 1;
                    for (OptionSetting optionSettingsListValue : optionSettingsList) {
                        if (optionSettingsListValue.name() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Name", StringConversion.fromString((String)optionSettingsListValue.name()));
                        }
                        if (optionSettingsListValue.value() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Value", StringConversion.fromString((String)optionSettingsListValue.value()));
                        }
                        if (optionSettingsListValue.defaultValue() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".DefaultValue", StringConversion.fromString((String)optionSettingsListValue.defaultValue()));
                        }
                        if (optionSettingsListValue.description() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".Description", StringConversion.fromString((String)optionSettingsListValue.description()));
                        }
                        if (optionSettingsListValue.applyType() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".ApplyType", StringConversion.fromString((String)optionSettingsListValue.applyType()));
                        }
                        if (optionSettingsListValue.dataType() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".DataType", StringConversion.fromString((String)optionSettingsListValue.dataType()));
                        }
                        if (optionSettingsListValue.allowedValues() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".AllowedValues", StringConversion.fromString((String)optionSettingsListValue.allowedValues()));
                        }
                        if (optionSettingsListValue.isModifiable() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".IsModifiable", StringConversion.fromBoolean((Boolean)optionSettingsListValue.isModifiable()));
                        }
                        if (optionSettingsListValue.isCollection() != null) {
                            request.addParameter("OptionsToInclude.OptionConfiguration." + optionsToIncludeListIndex + ".OptionSettings.OptionSetting." + optionSettingsListIndex + ".IsCollection", StringConversion.fromBoolean((Boolean)optionSettingsListValue.isCollection()));
                        }
                        ++optionSettingsListIndex;
                    }
                }
                ++optionsToIncludeListIndex;
            }
        }
        if (modifyOptionGroupRequest.optionsToRemove().isEmpty() && !(modifyOptionGroupRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("OptionsToRemove", "");
        } else if (!modifyOptionGroupRequest.optionsToRemove().isEmpty() && !(modifyOptionGroupRequest.optionsToRemove() instanceof SdkAutoConstructList)) {
            List<String> optionsToRemoveList = modifyOptionGroupRequest.optionsToRemove();
            int optionsToRemoveListIndex = 1;
            for (String optionsToRemoveListValue : optionsToRemoveList) {
                if (optionsToRemoveListValue != null) {
                    request.addParameter("OptionsToRemove.member." + optionsToRemoveListIndex, StringConversion.fromString((String)optionsToRemoveListValue));
                }
                ++optionsToRemoveListIndex;
            }
        }
        if (modifyOptionGroupRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)modifyOptionGroupRequest.applyImmediately()));
        }
        return request;
    }
}

