/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ModifyDbSnapshotAttributeRequest;

public class ModifyDbSnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifyDbSnapshotAttributeRequest>, ModifyDbSnapshotAttributeRequest> {
    public Request<ModifyDbSnapshotAttributeRequest> marshall(ModifyDbSnapshotAttributeRequest modifyDbSnapshotAttributeRequest) {
        if (modifyDbSnapshotAttributeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyDbSnapshotAttributeRequest, "RdsClient");
        request.addParameter("Action", "ModifyDBSnapshotAttribute");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDbSnapshotAttributeRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringConversion.fromString((String)modifyDbSnapshotAttributeRequest.dbSnapshotIdentifier()));
        }
        if (modifyDbSnapshotAttributeRequest.attributeName() != null) {
            request.addParameter("AttributeName", StringConversion.fromString((String)modifyDbSnapshotAttributeRequest.attributeName()));
        }
        if (modifyDbSnapshotAttributeRequest.valuesToAdd().isEmpty() && !(modifyDbSnapshotAttributeRequest.valuesToAdd() instanceof SdkAutoConstructList)) {
            request.addParameter("ValuesToAdd", "");
        } else if (!modifyDbSnapshotAttributeRequest.valuesToAdd().isEmpty() && !(modifyDbSnapshotAttributeRequest.valuesToAdd() instanceof SdkAutoConstructList)) {
            List<String> valuesToAddList = modifyDbSnapshotAttributeRequest.valuesToAdd();
            int valuesToAddListIndex = 1;
            for (String valuesToAddListValue : valuesToAddList) {
                if (valuesToAddListValue != null) {
                    request.addParameter("ValuesToAdd.AttributeValue." + valuesToAddListIndex, StringConversion.fromString((String)valuesToAddListValue));
                }
                ++valuesToAddListIndex;
            }
        }
        if (modifyDbSnapshotAttributeRequest.valuesToRemove().isEmpty() && !(modifyDbSnapshotAttributeRequest.valuesToRemove() instanceof SdkAutoConstructList)) {
            request.addParameter("ValuesToRemove", "");
        } else if (!modifyDbSnapshotAttributeRequest.valuesToRemove().isEmpty() && !(modifyDbSnapshotAttributeRequest.valuesToRemove() instanceof SdkAutoConstructList)) {
            List<String> valuesToRemoveList = modifyDbSnapshotAttributeRequest.valuesToRemove();
            int valuesToRemoveListIndex = 1;
            for (String valuesToRemoveListValue : valuesToRemoveList) {
                if (valuesToRemoveListValue != null) {
                    request.addParameter("ValuesToRemove.AttributeValue." + valuesToRemoveListIndex, StringConversion.fromString((String)valuesToRemoveListValue));
                }
                ++valuesToRemoveListIndex;
            }
        }
        return request;
    }
}

